<?php
/**
 * @author Bruno Massa http://drupal.org/user/67164
 * @file
 * Create true slideshows using any image over internet with many other features.
 */


/**
 * Module settings page. Users can set the default layout
 * of their charts.
 *
 * @ingroup form
 */
function _package_tour_admin_submit(&$from, &$form_state) {
  $settings = $form_state['values'];
  unset($settings['submit']);
  unset($settings['form_id']);
  unset($settings['form_build_id']);
  unset($settings['form_token']);
  unset($settings['op']);

  // Add a '#' in all field names
  foreach ($settings as $index => $value) {
    $settings["#$index"] = $value;
    unset($settings[$index]);
  }

  // Save the data into database
  variable_set('package_tour_settings', $settings);

  // Print a 'OK' message
  drupal_set_message(t('Settings saved'));
}



/**
 * Module Tour settings page. 
 */
function _package_tour_admin_add_form() {
	// Get the default settings for all slideshows
	$settings = variable_get('package_tour_settings', array());

	// Build the form
	$form['tour_cd'] = array(
			'#default_value'  => empty($settings['#tour_cd']) ? '' : $settings['#tour_cd'],
			'#description'    => t('Tour code for refer in content.'),
			'#title'          => t('Tour CD'),
			'#type'           => 'textfield',
    		'#required' => TRUE,
	);
	$form['display_order'] = array(
			'#default_value'  => '',
			'#description'    => t('Sorting for displaying on packaging tour.'),
			'#title'          => t('Display order'),
			'#type'           => 'textfield',
    		'#required' => TRUE,
	);
	
	$result = db_select('thtt_m_tour_category','a')
  	->fields('a', array('tour_category_id','tour_category_name'))
	->execute();
	 
	$categoryOption = array();
	 
	foreach($result as $item) {
		$categoryOption[$item->tour_category_id] = t($item->tour_category_name);
	}
	
	
	//---------- Get Node list ---------
	$result = db_select('node','a')
	->fields('a', array('nid','title'))
	->execute();
	
	$nodeOption = array();
	
	foreach($result as $item2) {
		$nodeOption[$item2->nid] = t($item2->title);
	}
	
	$default = !empty($form_state['values']['howmany_select']) ? $form_state['values']['howmany_select'] : 1;
	
	$form['howmany_select'] = array(
			'#title' => t('How many checkboxes do you want?'),
			'#type' => 'select',
			'#options' => array(1 => 1, 2 => 2, 3 => 3, 4 => 4),
			'#default_value' => $default,
			'#ajax' => array(
					'callback' => 'ajax_example_autocheckboxes_callback',
					'wrapper' => 'checkboxes-div',
					'method' => 'replace',
					'effect' => 'fade',
			),
			);
			
			
			$form['checkboxes_fieldset'] = array(
					'#title' => t("Generated Checkboxes"),
					// The prefix/suffix provide the div that we're replacing, named by
					// #ajax['wrapper'] above.
					'#prefix' => '',
					'#suffix' => '',
					'#type' => 'fieldset',
					'#description' => t('This is where we get automatically generated checkboxes'),
			);
				
	$form['tour_category_id'] = array(
			'#default_value'  => '',
			'#description'    => t('Tour category'),
			'#title'          => t('Tour Category'),
			'#type'           => 'select',
			'#options'        => $categoryOption,
    		'#required' => TRUE,
	);
	$form['nid'] = array(
			'#default_value'  => '',
			'#description'    => t('Link basic page'),
			'#title'          => t('Link basic page'),
			'#type'           => 'select',
			'#options'        => $nodeOption,
    		'#required' => TRUE,
	);
	$form['tour_name'] = array(
			'#default_value'  => '',
			'#description'    => t('Tour name'),
			'#title'          => t('Tour name'),
			'#type'           => 'textfield',
    		'#required' => TRUE,
	);
	$form['tour_short_desc'] = array(
			'#default_value'  => '',
			'#description'    => t('Short description'),
			'#title'          => t('Tour short description'),
			'#type'           => 'textarea',
    		'#required' => TRUE,
	);
	$form['tour_picture_path'] = array(
			'#default_value'  => '',
			'#description'    => t('Click "Browse..." to select an image to upload.'),
			'#title'          => t('Picture'),
			'#upload_location' => 'public://images',
			'#type'           => 'managed_file',
		    '#upload_validators' => array(
		        'file_validate_extensions' => array("png jpg jpeg gif"),
		    ),
	);
	$form['price_adult'] = array(
			'#default_value'  => '0.0',
			'#description'    => t('Original audult price'),
			'#title'          => t('Audult price'),
			'#type'           => 'textfield',
    		'#required' => TRUE,
	);
	$form['price_child'] = array(
			'#default_value'  => '0.0',
			'#description'    => t('Original child price'),
			'#title'          => t('Child price'),
			'#type'           => 'textfield',
    		'#required' => TRUE,
	);
	$form['price_new_adult'] = array(
			'#default_value'  => '0.0',
			'#description'    => t('New audult price'),
			'#title'          => t('New audult price'),
			'#type'           => 'textfield',
	);
	$form['price_new_child'] = array(
			'#default_value'  => '0.0',
			'#description'    => t('New child price'),
			'#title'          => t('New child price'),
			'#type'           => 'textfield',
	);
	$form['currency_cd'] = array(
			'#default_value'  => 'THB',
			'#description'    => t('Currency'),
			'#options'        => array(
					'THB'     => t('THB'),
					'US'      => t('US'),
			),
			'#title'          => t('Currency'),
			'#type'           => 'select',
    		'#required' => TRUE,
	);
	
	// Submit button
	$form['submit'] = array(
			'#value'          => t('Save tour'),
			'#type'           => 'submit',
	);

  return ($form);
}

function ajax_example_autocheckboxes_callback($form, $form_state) {
	return $form['checkboxes_fieldset'];
}
/**
 * Validate form
 *
 * @ingroup form
 */
function _package_tour_admin_add_form_validate($form, &$form_state) {
	if (!is_numeric($form_state['values']['display_order'])) {
		form_set_error('display_order', t('Field must be Numeric'));
	}
	if (!is_numeric($form_state['values']['price_adult'])) {
		form_set_error('price_adult', t('Field must be Numeric'));
	}
	if (!is_numeric($form_state['values']['price_child'])) {
		form_set_error('price_child', t('Field must be Numeric'));
	}
	if (!is_numeric($form_state['values']['price_new_adult'])) {
		form_set_error('price_new_adult', t('Field must be Numeric'));
	}
	if (!is_numeric($form_state['values']['price_new_child'])) {
		form_set_error('price_new_child', t('Field must be Numeric'));
	}
}

/**
 * Module settings page. Users can set the default layout
 * of their charts.
 *
 * @ingroup form
 */
function _package_tour_admin_add_form_submit($form, &$form_state) {
	$file = file_load($form_state['values']['tour_picture_path']);
	$file->status = FILE_STATUS_PERMANENT;
	file_save($file);
	
	$nid = db_insert('thtt_m_tour') // Table name no longer needs {}
	->fields(array(
			'tour_cd' => $form_state['values']['tour_cd'],
			'tour_category_id' => $form_state['values']['tour_category_id'],
			'tour_name' => $form_state['values']['tour_name'],
			'tour_short_desc' => $form_state['values']['tour_short_desc'],
			'nid' => $form_state['values']['nid'],
			'tour_picture_path' => $form_state['values']['tour_picture_path'],
			'price_adult' => $form_state['values']['price_adult'],
			'price_child' => $form_state['values']['price_child'],
			'price_new_adult' => $form_state['values']['price_new_adult'],
			'price_new_child' => $form_state['values']['price_new_child'],
			'display_order' => $form_state['values']['display_order'],
			'currency_cd' => $form_state['values']['currency_cd'],
			'create_by' => $GLOBALS['user']->name,
			'create_date' => date("Y-m-d H:i:s", time()),
			'update_by' => $GLOBALS['user']->name,
			'update_date' => date("Y-m-d H:i:s", time())
	))
	->execute();
	
	//drupal_flush_all_caches();
	
  	// Print a 'OK' message
  	drupal_set_message(t('Tour saved'));
  	
  	$form_state['redirect'] = 'admin/config/content/package_tour/tour/';
  	
}

/**
 * Module edit tour package page. Users can edit tour as requested.
 *
 * @ingroup form
 */
function _package_tour_admin_edit_form($form, $form_state, $tour_id) {
	$query = db_select('thtt_m_tour','t');
	$query->join('thtt_m_tour_category', 'u', 't.tour_category_id = u.tour_category_id');
	$result = $query
	->fields('t')
	->fields('u', array('tour_category_name'))
	->condition('t.tour_id',$tour_id)
	->execute();
	
	foreach($result as $item) {
		// Build the form
		
		$form['tour_id'] = array(
				'#type' => 'hidden',
				'#value' => $tour_id,
		);
		
		$form['tour_cd'] = array(
				'#default_value'  => $item->tour_cd,
				'#description'    => t('Tour code for refer in content.'),
				'#title'          => t('Tour CD'),
				'#type'           => 'textfield',
	    		'#required' => TRUE,
		);
		$form['display_order'] = array(
				'#default_value'  => $item->display_order,
				'#description'    => t('Sorting for displaying on packaging tour.'),
				'#title'          => t('Display order'),
				'#type'           => 'textfield',
	    		'#required' => TRUE,
		);
		
		//---------- Get Category list ---------
		$result = db_select('thtt_m_tour_category','a')
	  	->fields('a', array('tour_category_id','tour_category_name'))
		->execute();
		
		$categoryOption = array();
		
		foreach($result as $item2) {
			$categoryOption[$item2->tour_category_id] = t($item2->tour_category_name);
		}
		
		//---------- Get Node list ---------
		$result = db_select('node','a')
		->fields('a', array('nid','title'))
		->execute();
		
		$nodeOption = array();
		
		foreach($result as $item2) {
			$nodeOption[$item2->nid] = t($item2->title);
		}
		
		$form['tour_category_id'] = array(
				'#default_value'  => $item->tour_category_id,
				'#description'    => t('Tour category'),
				'#title'          => t('Tour Category'),
				'#type'           => 'select',
				'#options'        => $categoryOption,
	    		'#required' => TRUE,
		);
		$form['nid'] = array(
				'#default_value'  => $item->nid,
				'#description'    => t('Link basic page'),
				'#title'          => t('Link basic page'),
				'#type'           => 'select',
				'#options'        => $nodeOption,
	    		'#required' => TRUE,
		);
		$form['tour_name'] = array(
				'#default_value'  => $item->tour_name,
				'#description'    => t('Tour name'),
				'#title'          => t('Tour name'),
				'#type'           => 'textfield',
	    		'#required' => TRUE,
		);
		$form['tour_short_desc'] = array(
				'#default_value'  => $item->tour_short_desc,
				'#description'    => t('Short description'),
				'#title'          => t('Tour short description'),
				'#type'           => 'textarea',
	    		'#required' => TRUE,
		);
		$form['tour_picture_path'] = array(
				'#default_value'  => $item->tour_picture_path,
				'#description'    => t('Click "Browse..." to select an image to upload.'),
				'#title'          => t('Picture'),
				'#upload_location' => 'public://images',
				'#type'           => 'managed_file',
			    '#upload_validators' => array(
			        'file_validate_extensions' => array("png jpg jpeg gif"),
			    ),
		);
		$form['price_adult'] = array(
				'#default_value'  => $item->price_adult,
				'#description'    => t('Original audult price'),
				'#title'          => t('Audult price'),
				'#type'           => 'textfield',
	    		'#required' => TRUE,
		);
		$form['price_child'] = array(
				'#default_value'  => $item->price_child,
				'#description'    => t('Original child price'),
				'#title'          => t('Child price'),
				'#type'           => 'textfield',
	    		'#required' => TRUE,
		);
		$form['price_new_adult'] = array(
				'#default_value'  => $item->price_new_adult,
				'#description'    => t('New audult price'),
				'#title'          => t('New audult price'),
				'#type'           => 'textfield',
		);
		$form['price_new_child'] = array(
				'#default_value'  => $item->price_new_child,
				'#description'    => t('New child price'),
				'#title'          => t('New child price'),
				'#type'           => 'textfield',
		);
		$form['currency_cd'] = array(
				'#default_value'  => $item->currency_cd,
				'#description'    => t('Currency'),
				'#options'        => array(
						'THB'     => t('THB'),
						'US'      => t('US'),
				),
				'#title'          => t('Currency'),
				'#type'           => 'select',
	    		'#required' => TRUE,
		);
		
		// Submit button
		$form['submit'] = array(
				'#value'          => t('Save'),
				'#type'           => 'submit',
		);
	}
  return ($form);
}


/**
 * Module settings page. Users can set the default layout
 * of their charts.
 *
 * @ingroup form
 */
function _package_tour_admin_edit_form_submit($form, &$form_state) {
	
	$file = file_load($form_state['values']['tour_picture_path']);
	$file->status = FILE_STATUS_PERMANENT;
	file_save($file);
	file_usage_add($file, 'package_tour', 'image', $form_state['values']['tour_picture_path']);
	
	$nid = db_update('thtt_m_tour') // Table name no longer needs {}
	->fields(array(
			'tour_cd' => $form_state['values']['tour_cd'],
			'tour_category_id' => $form_state['values']['tour_category_id'],
			'tour_name' => $form_state['values']['tour_name'],
			'tour_short_desc' => $form_state['values']['tour_short_desc'],
			'nid' => $form_state['values']['nid'],
			'tour_picture_path' => $form_state['values']['tour_picture_path'],
			'price_adult' => $form_state['values']['price_adult'],
			'price_child' => $form_state['values']['price_child'],
			'price_new_adult' => $form_state['values']['price_new_adult'],
			'price_new_child' => $form_state['values']['price_new_child'],
			'currency_cd' => $form_state['values']['currency_cd'],
			'display_order' => $form_state['values']['display_order'],
			'create_by' => $GLOBALS['user']->name,
			'create_date' => date("Y-m-d H:i:s", time()),
			'update_by' => $GLOBALS['user']->name,
			'update_date' => date("Y-m-d H:i:s", time())
	)) 
	->condition('tour_id', $form_state['values']['tour_id'])
	->execute();
	
	//drupal_flush_all_caches();
	// Print a 'OK' message
	drupal_set_message(t('Tour saved'));
	 
	$form_state['redirect'] = 'admin/config/content/package_tour/tour/';
	 
}


/**
 * Form builder for a tour delete
 */
function _package_tour_admin_delete_form($form, $form_state, $tour_id, $tour_name) {
	$form = array();

	$form['_tour_id'] = array(
			'#type' => 'value',
			'#value' => $tour_id,
	);

	$form['question'] = array(
			'#type' => 'item',
			'#markup' => t(
					'Are you sure that you want to delete tour <strong>%profile</strong>?', array(
							'%profile' => urldecode($tour_name)
					)
			),
	);

	$form['delete'] = array(
			'#type' => 'submit',
			'#id' => 'delete',
			'#value' => t('Delete'),
	);

	$form['back'] = array(
			'#type' => 'submit',
			'#id' => 'back',
			'#value' => t('Cancel'),
	);

	return $form;
}

/**
 * Submit form for a profile delete
 */
function _package_tour_admin_delete_form_submit($form, &$form_state) {
	$v = & $form_state['values'];

	if ($form_state['clicked_button']['#id'] == 'delete') {
		_tour_delete($v['_tour_id']);
		drupal_set_message(t('The tour was deleted.'));
	}
	
	//drupal_flush_all_caches();
	$form_state['redirect'] = 'admin/config/content/package_tour/tour';
}

/**
 * Remove a profile from the database.
 */
function _tour_delete($id) {
	db_delete('thtt_m_tour')
	->condition('tour_id', $id)
	->execute();
}


/**
 * Module Tour Category settings page.
 */
function _package_tour_admin_category_add_form() {
	
	$result = db_select('thtt_m_group','a')
	->fields('a', array('group_id','group_name'))
	->execute();
	
	$groupOption = array();
	
	foreach($result as $item) {
		$groupOption[$item->group_id] = t($item->group_name);
	}
	
	// Build the form
	$form['group_id'] = array(
			'#default_value'  => '',
			'#description'    => t('Tour Group'),
			'#title'          => t('Tour Group'),
			'#type'           => 'select',
			'#options'        => $groupOption,
			'#required' => TRUE,
	);

	$form['tour_category_name'] = array(
			'#default_value'  => '',
			'#description'    => t('Tour category name.'),
			'#title'          => t('Tour category name'),
			'#type'           => 'textfield',
			'#required' => TRUE,
	);
	
	$form['display_order'] = array(
			'#default_value'  => '',
			'#description'    => t('Sorting for displaying on packaging tour.'),
			'#title'          => t('Display order'),
			'#type'           => 'textfield',
    		'#required' => TRUE,
	);
	
	$form['slideshow_flg'] = array(
			'#default_value'  => 'Y',
			'#description'    => t('Check for using in slideshow.'),
			'#title'          => t('Slideshow'),
			'#type'           => 'checkbox',
	);

	$form['photo1'] = array(
			'#default_value'  => '',
			'#description'    => t('Click "Browse..." to select an image to upload.'),
			'#title'          => t('Picture 1'),
			'#upload_location' => 'public://images',
			'#type'           => 'managed_file',
		    '#upload_validators' => array(
		        'file_validate_extensions' => array("png jpg jpeg gif"),
		    ),
	);
	$form['photo2'] = array(
			'#default_value'  => '',
			'#description'    => t('Click "Browse..." to select an image to upload.'),
			'#title'          => t('Picture 2'),
			'#upload_location' => 'public://images',
			'#type'           => 'managed_file',
		    '#upload_validators' => array(
		        'file_validate_extensions' => array("png jpg jpeg gif"),
		    ),
	);
	$form['photo3'] = array(
			'#default_value'  => '',
			'#description'    => t('Click "Browse..." to select an image to upload.'),
			'#title'          => t('Picture 3'),
			'#upload_location' => 'public://images',
			'#type'           => 'managed_file',
		    '#upload_validators' => array(
		        'file_validate_extensions' => array("png jpg jpeg gif"),
		    ),
	);
	$form['photo4'] = array(
			'#default_value'  => '',
			'#description'    => t('Click "Browse..." to select an image to upload.'),
			'#title'          => t('Picture 4'),
			'#upload_location' => 'public://images',
			'#type'           => 'managed_file',
		    '#upload_validators' => array(
		        'file_validate_extensions' => array("png jpg jpeg gif"),
		    ),
	);
	$form['photo5'] = array(
			'#default_value'  => '',
			'#description'    => t('Click "Browse..." to select an image to upload.'),
			'#title'          => t('Picture 5'),
			'#upload_location' => 'public://images',
			'#type'           => 'managed_file',
		    '#upload_validators' => array(
		        'file_validate_extensions' => array("png jpg jpeg gif"),
		    ),
	);
	
	// Submit button
	$form['submit'] = array(
			'#value'          => t('Save category'),
			'#type'           => 'submit',
	);

	return ($form);
}

/**
 * Validate form category
 *
 * @ingroup form
 */
function _package_tour_admin_category_add_form_validate($form, &$form_state) {
	if (!is_numeric($form_state['values']['display_order'])) {
		form_set_error('display_order', t('Field must be Numeric'));
	}
	
	if($form_state['values']['slideshow_flg']==1){
		if($form_state['values']['photo1']==0 
			&& $form_state['values']['photo2']==0
			&& $form_state['values']['photo2']==0 
			&& $form_state['values']['photo2']==0 
			&& $form_state['values']['photo2']==0  ){
				form_set_error('photo1', t('If you need to slideshow, please add photo at least 1 photo for sliding show.'));
		}
	}
}

/**
 * Module add category page submit. 
 */
function _package_tour_admin_category_add_form_submit($form, &$form_state) {
	$slideshowFlg = 'N';
	if($form_state['values']['slideshow_flg'] != ""){
		$slideshowFlg = "Y";
	}
	
	if($form_state['values']['photo1'] != 0){
		$file = file_load($form_state['values']['photo1']);
		$file->status = FILE_STATUS_PERMANENT;
		file_save($file);
		file_usage_add($file, 'package_tour', 'image', $form_state['values']['photo1']);
	}
	if($form_state['values']['photo2'] != 0){
		$file = file_load($form_state['values']['photo2']);
		$file->status = FILE_STATUS_PERMANENT;
		file_save($file);
		file_usage_add($file, 'package_tour', 'image', $form_state['values']['photo2']);
	}
	if($form_state['values']['photo3'] != 0){
		$file = file_load($form_state['values']['photo3']);
		$file->status = FILE_STATUS_PERMANENT;
		file_save($file);
		file_usage_add($file, 'package_tour', 'image', $form_state['values']['photo3']);
	}
	if($form_state['values']['photo4'] != 0){
		$file = file_load($form_state['values']['photo4']);
		$file->status = FILE_STATUS_PERMANENT;
		file_save($file);
		file_usage_add($file, 'package_tour', 'image', $form_state['values']['photo4']);
	}
	if($form_state['values']['photo5'] != 0){
		$file = file_load($form_state['values']['photo5']);
		$file->status = FILE_STATUS_PERMANENT;
		file_save($file);
		file_usage_add($file, 'package_tour', 'image', $form_state['values']['photo5']);
	}
	
	$nid = db_insert('thtt_m_tour_category') // Table name no longer needs {}
	->fields(array(
			'tour_category_name' => $form_state['values']['tour_category_name'],
			'slideshow_flg' => $slideshowFlg,
			'display_order' => $form_state['values']['display_order'],
			'photo1' => $form_state['values']['photo1'],
			'photo2' => $form_state['values']['photo2'],
			'photo3' => $form_state['values']['photo3'],
			'photo4' => $form_state['values']['photo4'],
			'photo5' => $form_state['values']['photo5'],
			'create_by' => $GLOBALS['user']->name,
			'create_date' => date("Y-m-d H:i:s", time()),
			'update_by' => $GLOBALS['user']->name,
			'update_date' => date("Y-m-d H:i:s", time())
	))
	->execute();
	
	//drupal_flush_all_caches();
	// Print a 'OK' message
	drupal_set_message(t('Tour Category saved'));
	 
	$form_state['redirect'] = 'admin/config/content/package_tour/category';
	 
}

/**
 * Module Tour Category edit page.
 */
function _package_tour_admin_category_edit_form($form, $form_state, $tour_category_id) {
	$result = db_select('thtt_m_tour_category','t')
			->fields('t')
			->condition('t.tour_category_id',$tour_category_id)
			->execute();
	
	foreach($result as $item) {
		// Build the form
		$form['tour_category_id'] = array(
				'#type' => 'hidden',
				'#value' => $tour_category_id,
		);
	
		$form['tour_category_name'] = array(
				'#default_value'  => $item->tour_category_name,
				'#description'    => t('Tour category name.'),
				'#title'          => t('Tour category name'),
				'#type'           => 'textfield',
				'#required' => TRUE,
		);
	
		$form['display_order'] = array(
				'#default_value'  => $item->display_order,
				'#description'    => t('Sorting for displaying on packaging tour.'),
				'#title'          => t('Display order'),
				'#type'           => 'textfield',
				'#required' => TRUE,
		);
	
		if($item->slideshow_flg == "Y" ){
			$defaultSlideshow = 1;
		}else{
			$defaultSlideshow = 0;
		}
		
		$form['slideshow_flg'] = array(
				'#default_value'  => $defaultSlideshow,
				'#description'    => t('Check for using in slideshow.'),
				'#title'          => t('Slideshow'),
				'#type'           => 'checkbox',
		);
		
		$form['photo1_old'] = array(
				'#type' => 'hidden',
				'#value' => $item->photo1,
		);
		
		$form['photo2_old'] = array(
				'#type' => 'hidden',
				'#value' => $item->photo2,
		);
		
		$form['photo3_old'] = array(
				'#type' => 'hidden',
				'#value' => $item->photo3,
		);
		
		$form['photo4_old'] = array(
				'#type' => 'hidden',
				'#value' => $item->photo4,
		);
		
		$form['photo5_old'] = array(
				'#type' => 'hidden',
				'#value' => $item->photo5,
		);
		
		$form['photo1'] = array(
				'#default_value'  => $item->photo1,
				'#description'    => t('Click "Browse..." to select an image to upload.'),
				'#title'          => t('Picture 1'),
				'#upload_location' => 'public://images',
				'#type'           => 'managed_file',
			    '#upload_validators' => array(
			        'file_validate_extensions' => array("png jpg jpeg gif"),
			    ),
		);
		$form['photo2'] = array(
				'#default_value'  => $item->photo2,
				'#description'    => t('Click "Browse..." to select an image to upload.'),
				'#title'          => t('Picture 2'),
				'#upload_location' => 'public://images',
				'#type'           => 'managed_file',
			    '#upload_validators' => array(
			        'file_validate_extensions' => array("png jpg jpeg gif"),
			    ),
		);
		$form['photo3'] = array(
				'#default_value'  => $item->photo3,
				'#description'    => t('Click "Browse..." to select an image to upload.'),
				'#title'          => t('Picture 3'),
				'#upload_location' => 'public://images',
				'#type'           => 'managed_file',
			    '#upload_validators' => array(
			        'file_validate_extensions' => array("png jpg jpeg gif"),
			    ),
		);
		$form['photo4'] = array(
				'#default_value'  => $item->photo4,
				'#description'    => t('Click "Browse..." to select an image to upload.'),
				'#title'          => t('Picture 4'),
				'#upload_location' => 'public://images',
				'#type'           => 'managed_file',
			    '#upload_validators' => array(
			        'file_validate_extensions' => array("png jpg jpeg gif"),
			    ),
		);
		$form['photo5'] = array(
				'#default_value'  => $item->photo5,
				'#description'    => t('Click "Browse..." to select an image to upload.'),
				'#title'          => t('Picture 5'),
				'#upload_location' => 'public://images',
				'#type'           => 'managed_file',
			    '#upload_validators' => array(
			        'file_validate_extensions' => array("png jpg jpeg gif"),
			    ),
		);
	
		// Submit button
		$form['submit'] = array(
				'#value'          => t('Save category'),
				'#type'           => 'submit',
		);
	}
	
	return ($form);
}

/**
 * Validate form category
 *
 * @ingroup form
 */
function _package_tour_admin_category_edit_form_validate($form, &$form_state) {
	if (!is_numeric($form_state['values']['display_order'])) {
		form_set_error('display_order', t('Field must be Numeric'));
	}
	
	if($form_state['values']['slideshow_flg']==1){
		if($form_state['values']['photo1']==0
				&& $form_state['values']['photo2']==0
				&& $form_state['values']['photo3']==0
				&& $form_state['values']['photo4']==0
				&& $form_state['values']['photo5']==0  ){
			form_set_error('photo1', t('If you need to slideshow, please add photo at least 1 photo for sliding show.'));
		}
	}
	
}

/**
 * Module add category page submit.
 */
function _package_tour_admin_category_edit_form_submit($form, &$form_state) {
	
	$slideshowFlg = 'N';
	if($form_state['values']['slideshow_flg'] != ""){
		$slideshowFlg = "Y";
	}
	if($form_state['values']['photo1_old'] != $form_state['values']['photo1'] && $form_state['values']['photo1'] != 0){
		$file = file_load($form_state['values']['photo1']);
		$file->status = FILE_STATUS_PERMANENT;
		file_save($file);
		file_usage_add($file, 'package_tour', 'image', $form_state['values']['photo1']);
	}
	if($form_state['values']['photo2_old'] != $form_state['values']['photo2'] && $form_state['values']['photo2'] != 0){
		$file = file_load($form_state['values']['photo2']);
		$file->status = FILE_STATUS_PERMANENT;
		file_save($file);
		file_usage_add($file, 'package_tour', 'image', $form_state['values']['photo2']);
	}
	if($form_state['values']['photo3_old'] != $form_state['values']['photo3'] && $form_state['values']['photo3'] != 0){
		$file = file_load($form_state['values']['photo3']);
		$file->status = FILE_STATUS_PERMANENT;
		file_save($file);
		file_usage_add($file, 'package_tour', 'image', $form_state['values']['photo3']);
	}
	if($form_state['values']['photo4_old'] != $form_state['values']['photo4'] && $form_state['values']['photo4'] != 0){
		$file = file_load($form_state['values']['photo4']);
		$file->status = FILE_STATUS_PERMANENT;
		file_save($file);
		file_usage_add($file, 'package_tour', 'image', $form_state['values']['photo4']);
	}
	if($form_state['values']['photo5_old'] != $form_state['values']['photo5'] && $form_state['values']['photo5'] != 0){
		$file = file_load($form_state['values']['photo5']);
		$file->status = FILE_STATUS_PERMANENT;
		file_save($file);
		file_usage_add($file, 'package_tour', 'image', $form_state['values']['photo5']);
	}
	
	$nid = db_update('thtt_m_tour_category') // Table name no longer needs {}
	->fields(array(
			'tour_category_name' => $form_state['values']['tour_category_name'],
			'slideshow_flg' => $slideshowFlg,
			'display_order' => $form_state['values']['display_order'],
			'photo1' => $form_state['values']['photo1'],
			'photo2' => $form_state['values']['photo2'],
			'photo3' => $form_state['values']['photo3'],
			'photo4' => $form_state['values']['photo4'],
			'photo5' => $form_state['values']['photo5'],
			'create_by' => $GLOBALS['user']->name,
			'create_date' => date("Y-m-d H:i:s", time()),
			'update_by' => $GLOBALS['user']->name,
			'update_date' => date("Y-m-d H:i:s", time())
	))
	->condition('tour_category_id', $form_state['values']['tour_category_id'])
	->execute();
	
	//drupal_flush_all_caches();
	// Print a 'OK' message
	drupal_set_message(t('Tour Category saved'));

	$form_state['redirect'] = 'admin/config/content/package_tour/category';
}


/**
 * Form builder for a tour delete
 */
function _package_tour_admin_category_delete_form($form, $form_state, $category_id, $category_name) {
	$form = array();

	$form['tour_category_id'] = array(
			'#type' => 'value',
			'#value' => $category_id,
	);

	$form['question'] = array(
			'#type' => 'item',
			'#markup' => t(
					'Are you sure that you want to delete tour category <strong>%name</strong>?', array(
							'%name' => urldecode($category_name)
					)
			),
	);

	$form['delete'] = array(
			'#type' => 'submit',
			'#id' => 'delete',
			'#value' => t('Delete'),
	);

	$form['back'] = array(
			'#type' => 'submit',
			'#id' => 'back',
			'#value' => t('Cancel'),
	);

	return $form;
}

/**
 * Submit form for a profile delete
 */
function _package_tour_admin_category_delete_form_submit($form, &$form_state) {
	$v = & $form_state['values'];

	if ($form_state['clicked_button']['#id'] == 'delete') {
		db_delete('thtt_m_tour_category')
		->condition('tour_category_id', $v['tour_category_id'])
		->execute();
		drupal_set_message(t('The tour category was deleted.'));
	}
	
	//drupal_flush_all_caches();
	$form_state['redirect'] = 'admin/config/content/package_tour/category';
}

